#include <stdio.h>
#include <mpi.h>
#include <omp.h>
int main(int argc, char **argv)
{
    int myid, nprocs;
    char hname[128]="";

    const int nlp=100;
    int i,tmax,tid;

    MPI_Init(&argc,&argv);
    MPI_Comm_size(MPI_COMM_WORLD,&nprocs);
    MPI_Comm_rank(MPI_COMM_WORLD,&myid);

    gethostname(hname,sizeof(hname));
    if (myid==0)
        printf ("NUMBER OF PROCESSES: %3d\n", nprocs);

    tmax=omp_get_max_threads();
    printf("MAXIMUM NUMBER OF THREADS: %2d\n", tmax);

    #pragma omp parallel private(tid)
    {
        tid=omp_get_thread_num();
        #pragma omp for
        for(i=1;i<=nlp;i++)
            printf("HELLO WORLD! (HOST NAME: %10s, MYID: %3d, TID: %2d, I: %5d)\n", hname, myid, tid, i);
    }

    MPI_Finalize();

    return 0;
}
